/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.player;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.StartBreakBlockEvent;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.KeyPressEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.notifications.NotificationType;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.settings.BindSetting;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.inventory.InventoryUtility;
import Krasnodar.rockstarnew.utility.inventory.ItemSlot;
import Krasnodar.rockstarnew.utility.inventory.group.SlotGroup;
import Krasnodar.rockstarnew.utility.inventory.group.SlotGroups;
import Krasnodar.rockstarnew.utility.inventory.slots.HotbarSlot;
import Krasnodar.rockstarnew.utility.rotations.MoveCorrection;
import Krasnodar.rockstarnew.utility.rotations.Rotation;
import Krasnodar.rockstarnew.utility.rotations.RotationHandler;
import Krasnodar.rockstarnew.utility.rotations.RotationPriority;
import Krasnodar.rockstarnew.utility.time.Timer;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_2886;

@ModuleInfo(name="Mine Helper", category=ModuleCategory.PLAYER, desc="\u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a \u0432 \u0448\u0430\u0445\u0442\u0435")
public class MineHelper
extends BaseModule {
    private final BooleanSetting save = new BooleanSetting((SettingsContainer)this, "\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u043a\u0438\u0440\u043a\u0443", "\u041d\u0435 \u0434\u0430\u0435\u0442 \u0441\u043b\u043e\u043c\u0430\u0442\u044c \u0431\u043b\u043e\u043a, \u0435\u0441\u043b\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0434\u043e\u0441\u0442\u0438\u0433 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u0438").enable();
    public final SliderSetting percent = new SliderSetting(this, "\u041f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u044c").step(1.0f).min(1.0f).max(70.0f).currentValue(10.0f).suffix("%");
    private final BooleanSetting autoReplace = new BooleanSetting((SettingsContainer)this, "\u0410\u0432\u0442\u043e \u0437\u0430\u043c\u0435\u043d\u0430", "\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043c\u0435\u043d\u044f\u0435\u0442 \u043a\u0438\u0440\u043a\u0443 \u043f\u0440\u0438 \u043d\u0438\u0437\u043a\u043e\u0439 \u043f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u0438");
    private final BooleanSetting autoRepair = new BooleanSetting((SettingsContainer)this, "\u0410\u0432\u0442\u043e \u043f\u043e\u0447\u0438\u043d\u043a\u0430", "\u0427\u0438\u043d\u0438\u0442 \u043a\u0438\u0440\u043a\u0443 \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u043e\u043f\u044b\u0442\u0430");
    private final BindSetting bind = new BindSetting(this, "\u041a\u043d\u043e\u043f\u043a\u0430 \u043f\u043e\u0447\u0438\u043d\u043a\u0438", () -> !this.autoRepair.isEnabled());
    private final Timer timer = new Timer();
    private boolean rotate;
    private final EventListener<KeyPressEvent> onKeyPressEvent = event -> {
        if (this.bind.isKey(event.getKey()) && event.getAction() == 1) {
            this.rotate = true;
            this.repairPickaxeWithBottle();
        }
    };
    private final EventListener<StartBreakBlockEvent> onStartBreakBlockEvent = event -> {
        class_1799 currentStack;
        if (MineHelper.mc.field_1724 != null && this.isValidPickaxe(currentStack = MineHelper.mc.field_1724.method_6047())) {
            double durabilityPercent = this.getDurabilityPercent(currentStack);
            if (this.save.isEnabled() && !(durabilityPercent >= (double)this.percent.getCurrentValue())) {
                event.cancel();
                this.handleLowDurability(currentStack);
            }
        }
    };
    private final EventListener<ClientPlayerTickEvent> onUpdateEvent = event -> {
        if (MineHelper.mc.field_1724 != null && this.rotate) {
            Rockstar.getInstance().getRotationHandler().rotate(new Rotation(MineHelper.mc.field_1724.method_36454(), 90.0f), MoveCorrection.SILENT, 180.0f, 180.0f, 180.0f, RotationPriority.USE_ITEM);
        }
    };

    private void handleLowDurability(class_1799 currentStack) {
        boolean switched = false;
        if (this.autoReplace.isEnabled()) {
            switched = this.trySwitchPickaxe(currentStack);
        }
        if (!switched && this.timer.finished(800L)) {
            Rockstar.getInstance().getNotificationManager().addNotificationOther(NotificationType.ERROR, "\u041a\u0438\u0440\u043a\u0430 \u043f\u043e\u0447\u0442\u0438 \u0441\u043b\u043e\u043c\u0430\u043d\u0430!", "\u041d\u0435\u0442 \u0437\u0430\u043c\u0435\u043d\u044b/\u043e\u043f\u044b\u0442\u0430 \u0434\u043b\u044f \u043f\u043e\u0447\u0438\u043d\u043a\u0438");
            this.timer.reset();
        }
    }

    private void repairPickaxeWithBottle() {
        if (MineHelper.mc.field_1724 != null && MineHelper.mc.field_1755 == null) {
            class_1799 pickaxe = MineHelper.mc.field_1724.method_6047();
            if (!this.isValidPickaxe(pickaxe) || pickaxe.method_7919() == 0) {
                Rockstar.getInstance().getNotificationManager().addNotificationOther(NotificationType.ERROR, "\u041e\u0448\u0438\u0431\u043a\u0430", "\u041d\u0435\u0442 \u043a\u0438\u0440\u043a\u0438 \u0438\u043b\u0438 \u043e\u043d\u0430 \u043d\u0435 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0430!");
                this.rotate = false;
            } else if (this.ensureBottleInOffhand()) {
                this.useExperienceBottle();
            }
        }
    }

    private boolean ensureBottleInOffhand() {
        class_1799 offhand = MineHelper.mc.field_1724.method_6079();
        if (offhand.method_7909() == class_1802.field_8287) {
            return true;
        }
        SlotGroup<ItemSlot> searchArea = SlotGroups.inventory().and(SlotGroups.hotbar());
        ItemSlot bottleSlot = searchArea.findItem(stack -> stack.method_7909() == class_1802.field_8287);
        if (bottleSlot == null) {
            Rockstar.getInstance().getNotificationManager().addNotificationOther(NotificationType.ERROR, "\u041d\u0435\u0442 \u0431\u0443\u0442\u044b\u043b\u043e\u043a \u043e\u043f\u044b\u0442\u0430!", "\u0412\u0430\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u043c\u0435\u0442\u044c \u0431\u0443\u0442\u044b\u043b\u043e\u0447\u043a\u0438 \u043e\u043f\u044b\u0442\u0430 \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435");
            this.rotate = false;
            return false;
        }
        InventoryUtility.moveItem(bottleSlot, InventoryUtility.getOffHandSlot());
        return true;
    }

    private void useExperienceBottle() {
        if (MineHelper.mc.field_1724.method_6079().method_7909() != class_1802.field_8287) {
            MineHelper.mc.field_1690.field_1904.method_23481(false);
            this.rotate = false;
        } else {
            RotationHandler rotation = Rockstar.getInstance().getRotationHandler();
            MineHelper.mc.field_1761.method_41931(MineHelper.mc.field_1687, sequence -> new class_2886(class_1268.field_5810, sequence, rotation.getServerRotation().getYaw(), rotation.getServerRotation().getYaw()));
        }
    }

    private boolean trySwitchPickaxe(class_1799 currentStack) {
        HotbarSlot bestSlot = this.findBestPickaxeSlot(currentStack);
        if (bestSlot == null) {
            return false;
        }
        InventoryUtility.selectHotbarSlot(bestSlot);
        if (this.timer.finished(800L)) {
            class_1799 newStack = bestSlot.itemStack();
            Rockstar.getInstance().getNotificationManager().addNotificationOther(NotificationType.SUCCESS, "\u0417\u0430\u043c\u0435\u043d\u0430 \u043a\u0438\u0440\u043a\u0438", String.format("\u0417\u0430\u043c\u0435\u043d\u0438\u043b \u043a\u0438\u0440\u043a\u0443 \u0441 %.1f%% \u043d\u0430 %.1f%%", this.getDurabilityPercent(currentStack), this.getDurabilityPercent(newStack)));
            this.timer.reset();
        }
        return true;
    }

    private HotbarSlot findBestPickaxeSlot(class_1799 currentStack) {
        double currentDurability = this.getDurabilityPercent(currentStack);
        HotbarSlot bestSlot = null;
        double bestDurability = currentDurability;
        for (int i = 0; i < 9; ++i) {
            double durability;
            HotbarSlot slot = InventoryUtility.getHotbarSlot(i);
            class_1799 stack = slot.itemStack();
            if (!this.isValidPickaxe(stack) || !((durability = this.getDurabilityPercent(stack)) > bestDurability)) continue;
            bestDurability = durability;
            bestSlot = slot;
        }
        return bestSlot;
    }

    private boolean isValidPickaxe(class_1799 stack) {
        return stack != null && stack.method_7963() && stack.method_7909() instanceof class_1810;
    }

    private double getDurabilityPercent(class_1799 stack) {
        return (double)(stack.method_7936() - stack.method_7919()) / (double)stack.method_7936() * 100.0;
    }
}

